package com.richard_gauthier.GestionPortSerie 
{
	import com.quetwo.Arduino.ArduinoConnector;
	import com.quetwo.Arduino.ArduinoConnectorEvent;
	import org.osflash.signals.Signal;
	/**
	 * ...
	 * @author rg
	 */
	public class GestionPortSerie 
	{
		private var _port:ArduinoConnector;
		public var eventSurPortSerie : Signal = new Signal();
		
		public function GestionPortSerie() 
		{ }
		
		public function connect( portName:String = "COM3", baudRate:int = 9600 ):void {
 
			_port = new ArduinoConnector();
			var result:Boolean = _port.connect( portName, baudRate );
 
			if( ! result || ! _port.portOpen ) {
				throw new Error( "Failed to connect to serial port" );
			}
 
			_port.addEventListener( "socketData",bitRecus);
		}
		
		private function bitRecus( event:ArduinoConnectorEvent ):void {
 
				//event.target === _port
 
				var buffer : String = ""; 
				var tempArray: Array = _port.readBytesAsArray();
				
				var lgtempArray: int = tempArray.length;
				for (var i:int = 0; i < lgtempArray ; i++) 
				{
				buffer += tempArray[i];
				}
				
				if (buffer != " ") 
				eventSurPortSerie.dispatch(buffer);
 
			}
 
		public function close():void {
			if( _port ) {
				if( _port.portOpen ) {
					_port.close();
				}
				_port.dispose();
			}
		}
		
		
		
		public function SerialPrint(ChainedeCaractere :String):void {
			
			_port.writeString(ChainedeCaractere);
			
		}
		
	}

}